#Fig 1B_PD50 for peptides
setwd('~/Documents/Research_Projects/LEA_CAHS_Oligomerization')

#call in packages
library(tidyverse)
library(dplyr)
library(purrr)
library(broom)
library(stringr)
library(ggplot2)
library(plotly)
library(readxl)
library(RColorBrewer)
library(patchwork)
library(grid)
library(ggsignif)
library(scales)
#Motif
PD50_Motif <- read_xlsx('Figure_1_PD50.xlsx', sheet = 'Motif')
PD50_Motif$Additive <- factor(PD50_Motif$Additive, levels = c('At11', 'At22','At44', 'Aav11', 'He11', 'Av11', 'At20', 'Trehalose','Sucrose'))
#make graph 
Motif <-ggplot(data = PD50_Motif, aes(x = Additive, y = PD50*100, fill = Additive))+
  geom_col(position = position_dodge(width = .9), color = 'black', size = 0.25)+
  theme_bw()+
  theme(
    plot.title = element_text(hjust = .5, size = 8),
    axis.title.y = element_text(size =8),
    axis.text.y = element_text(size =8),
    axis.title.x = element_text(size = 8),
    axis.text.x = element_text(size =8, angle = 45, hjust = 1),
    legend.text=element_text(size=14),
    legend.position = 'none', aspect.ratio = 1,
    legend.title = element_blank(),
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  labs(x = '',
       y = expression('PD50 (mM)'),
       title = '')+
  scale_fill_manual(values = c('#6BA5C8','#4462AC','#3CC0C9','#5ABA56','#9337FF','#918F00','#CD5B45','#0433FF','#FF9200'))+
  geom_errorbar(aes(ymin = PD50*100 - STD*100, ymax = PD50*100 + STD*100), width = .2, position = position_dodge(.9))+
  scale_y_continuous(trans = 'log10', limits = c(1,10000),
                     breaks = c(1,10,100,1000,10000),
                     labels = c(0.01,0.1,1,10,100))


#Patchwork
Motif+ FL+plot_layout(ncol = 4)
#export 6x7


###Fig 1C_Example plot

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Example.xlsx')
#Change the factor order
data$Ratio <- factor(data$Sample,levels = c('Protein1',
                                            'Protein2',
                                            'Protein3'
))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Sample, y = Protect_add, fill = interaction(Sample, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = '',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(48,88,48),
    xmin = c(.75, 1.75, 2.75),
    xmax = c(1.25, 2.25, 3.25),
    annotation = c("NS", "***", "***"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("Protein1", "Protein2","Protein3"),
                   labels=c("Protein1", "Protein2","Protein3"))


###Fig 1D_Peptide Synergy with Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Figure_1_LEA_Synergy.xlsx', sheet = 'Peptide_Trehalose')
#Change the factor order
data$Sample <- factor(data$Sample,levels = c(
  'At11',
  'At22',
  'At44',
  'Aav11',
  'He11',
  'Av11',
  'At20'))


#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Sample, y = Protect_add, fill = interaction(Sample, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = ' LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,90))+  
  #Set graph labels
  labs(x = 'LEA Motif',
       y = 'LDH Protection (%)',
       title = 'Trehalose: Peptide')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c( 'skyblue1','dodgerblue1', 'turquoise1', 'seagreen1', 'mediumpurple1','yellow1','coral1',
                              'skyblue3', 'dodgerblue3', 'turquoise3', 'seagreen3', 'mediumpurple3', 'yellow3','coral3'))+
  
  #add significane values
  geom_signif(
    y_position = c(55, 55, 28, 28,73,52, 82),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75,5.75, 6.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25, 6.25, 7.25),
    annotation = c("NS", "**", "NS", "NS","NS", "**", "***"),
    tip_length = 0, color = "black")

#Export PDF 5.94 x 6.34 Landscape



###Fig 1E_Peptide synergy with sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Figure_1_LEA_Synergy.xlsx', sheet = 'Peptide_Sucrose')
#Change the factor order
data$Sample <- factor(data$Sample,levels = c(
  'At11',
  'At22',
  'At44',
  'Aav11',
  'He11',
  'Av11',
  'At20'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Sample, y = Protect_add, fill = interaction(Sample, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = ' LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,90))+  
  #Set graph labels
  labs(x = 'LEA Motif',
       y = 'LDH Protection (%)',
       title = 'Sucrose: Peptide')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c( 'skyblue1','dodgerblue1', 'turquoise1', 'seagreen1', 'mediumpurple1','yellow1','coral1',
                              'skyblue3', 'dodgerblue3', 'turquoise3', 'seagreen3', 'mediumpurple3', 'yellow3','coral3'))+
  #add significane values
  geom_signif(
    y_position = c(20, 20, 18, 18, 38,27, 78),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75,5.75, 6.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25, 6.25, 7.25),
    annotation = c("*", "*", "NS", "NS","NS", "*", "***"),
    tip_length = 0, color = "black")



###Fig 1F_Trehalose vs sucrose synergy

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Figure_1E_Peptide Synergy_with_Sugars.xlsx')
#Change the factor order
data$Peptide <- factor(data$Peptide,levels = c('At11',
                                               'At22',
                                               'At44',
                                               'Av11',
                                               'He11',
                                               'At20',
                                               'Aav11'))
#build ggplot environment
ggplot(data = data, aes(x = `%synergy_tre`, y = `%synergy_suc`, fill = Peptide))+
  geom_point(size = 6.5, shape = 21, color = 'black')+
  theme_bw()+
  theme(panel.grid = element_blank(),
        plot.title = element_text(hjust = 0.05, size = 14, vjust = -8),
        axis.title = element_text(size =14),
        axis.text.y = element_text(size =12),
        axis.text.x = element_text(size =12),
        legend.text=element_text(size=14), 
        legend.position = 'none', aspect.ratio = 1,
        panel.border = element_rect(colour = "black", fill=NA, size=1))+
  scale_color_manual(values = c(
    'skyblue3', 'dodgerblue3', 'turquoise3', 'yellow3', 'mediumpurple3', 'coral3','seagreen3'))+
  geom_abline(linetype = 'dashed',
              linewidth = 1)+
  geom_errorbar(aes(ymin = `%synergy_suc` - `%synergy_suc_err`,
                    ymax = `%synergy_suc` + `%synergy_suc_err`),
                width = 1, position = position_dodge(.9))+
  geom_errorbarh(aes(xmin = `%synergy_tre` - `%synergy_tre_err`,
                     xmax = `%synergy_tre` + `%synergy_tre_err`),
                 height = 1, position = position_dodge(.9))+
  labs(
    x = 'Synergy with Trehalose (%)',
    y = 'Synergy with Sucrose (%)'
  )+
  scale_y_continuous(
    breaks = seq(-40,50,25),
    limits = c(-40,50))+
  xlim(-40,50)
